/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.event.AbstractTestConfigurationEvents;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHierarchicalConfigurationEvents
extends AbstractTestConfigurationEvents {
    private void checkSubnodeEvent(ConfigurationEvent event, boolean before) {
        Assertions.assertEquals((Object)before, (Object)event.isBeforeUpdate());
        ConfigurationEvent evSub = (ConfigurationEvent)Assertions.assertInstanceOf(ConfigurationEvent.class, (Object)event.getPropertyValue());
        Assertions.assertEquals((Object)ConfigurationEvent.ADD_PROPERTY, (Object)evSub.getEventType());
        Assertions.assertEquals((Object)"newProp", (Object)evSub.getPropertyName());
        Assertions.assertEquals((Object)"newValue", (Object)evSub.getPropertyValue());
        Assertions.assertEquals((Object)before, (Object)evSub.isBeforeUpdate());
    }

    @Override
    protected AbstractConfiguration createConfiguration() {
        return new BaseHierarchicalConfiguration();
    }

    @Test
    void testAddNodesEmptyEvent() {
        ((BaseHierarchicalConfiguration)this.config).addNodes("event.test", new ArrayList());
        this.listener.done();
    }

    @Test
    void testAddNodesEvent() {
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)this.config;
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>(1);
        nodes.add(NodeStructureHelper.createNode("a_key", "a value"));
        hc.addNodes("event.test", nodes);
        this.listener.checkEvent(ConfigurationEvent.ADD_NODES, "event.test", nodes, true);
        this.listener.checkEvent(ConfigurationEvent.ADD_NODES, "event.test", nodes, false);
        this.listener.done();
    }

    @Test
    void testClearTreeEvent() {
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)this.config;
        String key = "event.property".substring(0, "event.property".indexOf(46));
        NodeHandler nodeHandler = hc.getNodeModel().getNodeHandler();
        List nodes = hc.getExpressionEngine().query((Object)((ImmutableNode)nodeHandler.getRootNode()), key, nodeHandler);
        hc.clearTree(key);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_TREE, key, null, true);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_TREE, key, nodes, false);
        this.listener.done();
    }

    @Test
    void testSubConfigurationChangedEventConnected() {
        HierarchicalConfiguration sub = ((BaseHierarchicalConfiguration)this.config).configurationAt("event.property", true);
        sub.addProperty("newProp", (Object)"newValue");
        this.checkSubnodeEvent((ConfigurationEvent)this.listener.nextEvent(ConfigurationEvent.SUBNODE_CHANGED), true);
        this.checkSubnodeEvent((ConfigurationEvent)this.listener.nextEvent(ConfigurationEvent.SUBNODE_CHANGED), false);
        this.listener.done();
    }

    @Test
    void testSubConfigurationChangedEventNotConnected() {
        HierarchicalConfiguration sub = ((BaseHierarchicalConfiguration)this.config).configurationAt("event.property");
        sub.addProperty("newProp", (Object)"newValue");
        this.listener.done();
    }
}

