/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncServer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public abstract class HttpTestServer
extends AsyncServer {
    final SSLContext sslContext;
    final SSLSessionInitializer sslSessionInitializer;
    final SSLSessionVerifier sslSessionVerifier;
    final List<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries;
    HttpProcessor httpProcessor;
    Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator;

    public HttpTestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
        this.routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>>();
    }

    public HttpTestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public abstract InetSocketAddress start() throws Exception;

    void ensureNotRunning() {
        Asserts.check((this.getStatus() == IOReactorStatus.INACTIVE ? 1 : 0) != 0, (String)"Server is already running");
    }

    public void register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull(supplier, (String)"Exchange handler supplier");
        Asserts.check((this.getStatus() == IOReactorStatus.INACTIVE ? 1 : 0) != 0, (String)"Server has already been started");
        this.ensureNotRunning();
        this.routeEntries.add((RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>)new RequestRouter.Entry(uriPattern, supplier));
    }

    public <T> void register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, (Supplier<AsyncServerExchangeHandler>)((Supplier)() -> new BasicServerExchangeHandler(requestHandler)));
    }

    public void configure(HttpProcessor httpProcessor) {
        this.ensureNotRunning();
        this.httpProcessor = httpProcessor;
    }

    public void configure(Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator) {
        this.ensureNotRunning();
        this.exchangeHandlerDecorator = exchangeHandlerDecorator;
    }

    public InetSocketAddress startExecution(IOEventHandlerFactory handlerFactory) throws Exception {
        this.execute(handlerFactory);
        Future<ListenerEndpoint> future = this.listen(new InetSocketAddress(0));
        ListenerEndpoint listener = future.get();
        return (InetSocketAddress)listener.getAddress();
    }
}

