/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import java.util.Objects;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.RequiredPermission;

public final class ResourceFactory {
    private static final Resource CONTROLLER_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Controller.getValue();
        }

        public String getName() {
            return "Controller";
        }

        public String getSafeDescription() {
            return "the controller";
        }
    };
    private static final Resource FLOW_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Flow.getValue();
        }

        public String getName() {
            return "NiFi Flow";
        }

        public String getSafeDescription() {
            return "the user interface";
        }
    };
    private static final Resource POLICY_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Policy.getValue();
        }

        public String getName() {
            return "Policies for ";
        }

        public String getSafeDescription() {
            return "the policies for ";
        }
    };
    private static final Resource COUNTERS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Counters.getValue();
        }

        public String getName() {
            return "Counters";
        }

        public String getSafeDescription() {
            return "counters";
        }
    };
    private static final Resource PROVENANCE_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Provenance.getValue();
        }

        public String getName() {
            return "Provenance";
        }

        public String getSafeDescription() {
            return "provenance";
        }
    };
    private static final Resource PROVENANCE_DATA_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.ProvenanceData.getValue();
        }

        public String getName() {
            return "Provenance data for ";
        }

        public String getSafeDescription() {
            return "the provenance data for ";
        }
    };
    private static final Resource DATA_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Data.getValue();
        }

        public String getName() {
            return "Data for ";
        }

        public String getSafeDescription() {
            return "the data for ";
        }
    };
    private static final Resource PROXY_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Proxy.getValue();
        }

        public String getName() {
            return "Proxy User Requests";
        }

        public String getSafeDescription() {
            return "proxy requests on behalf of users";
        }
    };
    private static final Resource RESOURCE_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Resource.getValue();
        }

        public String getName() {
            return "NiFi Resources";
        }

        public String getSafeDescription() {
            return "resources";
        }
    };
    private static final Resource SITE_TO_SITE_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.SiteToSite.getValue();
        }

        public String getName() {
            return "Site to Site";
        }

        public String getSafeDescription() {
            return "site-to-site details";
        }
    };
    private static final Resource SYSTEM_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.System.getValue();
        }

        public String getName() {
            return "System";
        }

        public String getSafeDescription() {
            return "system diagnostics";
        }
    };
    private static final Resource RESTRICTED_COMPONENTS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.RestrictedComponents.getValue();
        }

        public String getName() {
            return "Restricted Components";
        }

        public String getSafeDescription() {
            return "restricted components";
        }
    };
    private static final Resource TENANT_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Tenant.getValue();
        }

        public String getName() {
            return "Tenant";
        }

        public String getSafeDescription() {
            return "users/user groups";
        }
    };
    private static final Resource POLICIES_RESOURCE = new Resource(){

        public String getIdentifier() {
            return "/policies";
        }

        public String getName() {
            return "Access Policies";
        }

        public String getSafeDescription() {
            return "policies";
        }
    };
    private static final Resource PARAMETER_CONTEXTS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.ParameterContext.getValue();
        }

        public String getName() {
            return "Parameter Contexts";
        }

        public String getSafeDescription() {
            return "parameter contexts";
        }
    };
    private static final Resource PARAMETER_PROVIDERS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.ParameterProvider.getValue();
        }

        public String getName() {
            return "Parameter Providers";
        }

        public String getSafeDescription() {
            return "parameter providers";
        }
    };

    public static Resource getControllerResource() {
        return CONTROLLER_RESOURCE;
    }

    public static Resource getFlowResource() {
        return FLOW_RESOURCE;
    }

    public static Resource getCountersResource() {
        return COUNTERS_RESOURCE;
    }

    public static Resource getParameterContextsResource() {
        return PARAMETER_CONTEXTS_RESOURCE;
    }

    public static Resource getParameterProvidersResource() {
        return PARAMETER_PROVIDERS_RESOURCE;
    }

    public static Resource getProvenanceResource() {
        return PROVENANCE_RESOURCE;
    }

    public static Resource getProxyResource() {
        return PROXY_RESOURCE;
    }

    public static Resource getResourceResource() {
        return RESOURCE_RESOURCE;
    }

    public static Resource getSiteToSiteResource() {
        return SITE_TO_SITE_RESOURCE;
    }

    public static Resource getSystemResource() {
        return SYSTEM_RESOURCE;
    }

    public static Resource getRestrictedComponentsResource() {
        return RESTRICTED_COMPONENTS_RESOURCE;
    }

    public static Resource getRestrictedComponentsResource(final RequiredPermission requiredPermission) {
        return new Resource(){

            public String getIdentifier() {
                return RESTRICTED_COMPONENTS_RESOURCE.getIdentifier() + "/" + requiredPermission.getPermissionIdentifier();
            }

            public String getName() {
                return requiredPermission.getPermissionLabel();
            }

            public String getSafeDescription() {
                return "Components requiring additional permission: " + requiredPermission.getPermissionLabel();
            }
        };
    }

    public static Resource getTenantResource() {
        return TENANT_RESOURCE;
    }

    public static Resource getDataTransferResource(final Resource resource) {
        Objects.requireNonNull(resource, "The resource must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return ResourceType.DataTransfer.getValue() + resource.getIdentifier();
            }

            public String getName() {
                return "Transfer data to " + resource.getName();
            }

            public String getSafeDescription() {
                return "data transfers to " + resource.getSafeDescription();
            }
        };
    }

    public static Resource getPoliciesResource() {
        return POLICIES_RESOURCE;
    }

    public static Resource getPolicyResource(final Resource resource) {
        Objects.requireNonNull(resource, "The resource type must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return POLICY_RESOURCE.getIdentifier() + resource.getIdentifier();
            }

            public String getName() {
                return POLICY_RESOURCE.getName() + resource.getName();
            }

            public String getSafeDescription() {
                return POLICY_RESOURCE.getSafeDescription() + resource.getSafeDescription();
            }
        };
    }

    public static Resource getOperationResource(final Resource resource) {
        Objects.requireNonNull(resource, "The resource type must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return ResourceType.Operation.getValue() + resource.getIdentifier();
            }

            public String getName() {
                return "Operations for" + resource.getName();
            }

            public String getSafeDescription() {
                return "Operations for" + resource.getSafeDescription();
            }
        };
    }

    public static Resource getComponentResource(final ResourceType resourceType, final String identifier, final String name) {
        Objects.requireNonNull(resourceType, "The resource must be specified.");
        Objects.requireNonNull(identifier, "The component identifier must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return resourceType.getValue() + "/" + identifier;
            }

            public String getName() {
                return name;
            }

            public String getSafeDescription() {
                String componentType = switch (resourceType) {
                    case ResourceType.ControllerService -> "Controller Service";
                    case ResourceType.ProcessGroup -> "Process Group";
                    case ResourceType.Funnel -> "Funnel";
                    case ResourceType.InputPort -> "Input Port";
                    case ResourceType.OutputPort -> "Output Port";
                    case ResourceType.Processor -> "Processor";
                    case ResourceType.RegistryClient -> "Registry Client";
                    case ResourceType.RemoteProcessGroup -> "Remote Process Group";
                    case ResourceType.ReportingTask -> "Reporting Task";
                    case ResourceType.FlowAnalysisRule -> "Flow Analysis Rule";
                    case ResourceType.Label -> "Label";
                    case ResourceType.ParameterContext -> "Parameter Context";
                    case ResourceType.ParameterProvider -> "Parameter Provider";
                    default -> "Component";
                };
                return componentType + " with ID " + identifier;
            }
        };
    }

    public static Resource getDataResource(final Resource resource) {
        return new Resource(){

            public String getIdentifier() {
                return DATA_RESOURCE.getIdentifier() + resource.getIdentifier();
            }

            public String getName() {
                return DATA_RESOURCE.getName() + resource.getName();
            }

            public String getSafeDescription() {
                return DATA_RESOURCE.getSafeDescription() + resource.getSafeDescription();
            }
        };
    }

    public static Resource getProvenanceDataResource(final Resource resource) {
        Objects.requireNonNull(resource, "The resource must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return String.format("%s%s", PROVENANCE_DATA_RESOURCE.getIdentifier(), resource.getIdentifier());
            }

            public String getName() {
                return PROVENANCE_DATA_RESOURCE.getName() + resource.getName();
            }

            public String getSafeDescription() {
                return PROVENANCE_DATA_RESOURCE.getSafeDescription() + resource.getSafeDescription();
            }
        };
    }

    private ResourceFactory() {
    }
}

