/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.cert;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.nifi.security.cert.CertificateAttributeReader;
import org.apache.nifi.security.cert.GeneralNameType;
import org.apache.nifi.security.cert.PeerIdentityProvider;
import org.apache.nifi.security.cert.StandardCertificateAttributeReader;
import org.apache.nifi.security.cert.SubjectAlternativeName;

public class StandardPeerIdentityProvider
implements PeerIdentityProvider {
    private final CertificateAttributeReader certificateAttributeReader = new StandardCertificateAttributeReader();

    @Override
    public Set<String> getIdentities(Certificate[] peerCertificates) throws SSLPeerUnverifiedException {
        if (peerCertificates == null || peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("Peer certificates not found");
        }
        Certificate peerCertificate = peerCertificates[0];
        if (peerCertificate instanceof X509Certificate) {
            X509Certificate certificate = (X509Certificate)peerCertificate;
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e) {
                String message = String.format("X.509 Peer certificate not valid: %s", e.getMessage());
                throw new SSLPeerUnverifiedException(message);
            }
            return this.getIdentities(certificate);
        }
        throw new SSLPeerUnverifiedException("X.509 Peer certificate not found");
    }

    private Set<String> getIdentities(X509Certificate certificate) {
        LinkedHashSet<String> identities = new LinkedHashSet<String>();
        List<SubjectAlternativeName> subjectAlternativeNames = this.certificateAttributeReader.getSubjectAlternativeNames(certificate);
        for (SubjectAlternativeName subjectAlternativeName : subjectAlternativeNames) {
            GeneralNameType generalNameType = subjectAlternativeName.getGeneralNameType();
            if (GeneralNameType.DNS_NAME != generalNameType) continue;
            String name = subjectAlternativeName.getName();
            identities.add(name);
        }
        return identities;
    }
}

