/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coordinate;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.coordinate.DefaultCoordinateMetadata;
import org.apache.sis.referencing.IdentifiedObjects;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;

public abstract class AbstractCoordinateSet
implements Iterable<DirectPosition>,
Serializable {
    private static final long serialVersionUID = 3656426153519035461L;
    private final DefaultCoordinateMetadata metadata;

    protected AbstractCoordinateSet(DefaultCoordinateMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public DefaultCoordinateMetadata getCoordinateMetadata() {
        return this.metadata;
    }

    public int getDimension() {
        return this.getCoordinateMetadata().getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
    }

    @Override
    @UML(identifier="coordinateTuple", obligation=Obligation.MANDATORY, specification=Specification.ISO_19111)
    public abstract Iterator<DirectPosition> iterator();

    public Stream<DirectPosition> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CoordinateSet");
        sb.append('[').append(IdentifiedObjects.getDisplayName((IdentifiedObject)this.metadata.getCoordinateReferenceSystem(), null));
        this.metadata.getCoordinateEpoch().ifPresent(epoch -> sb.append(" @ ").append(epoch));
        return sb.toString();
    }
}

