/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import java.io.PrintWriter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.sling.commons.log.logback.internal.Tailer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilteringListener
implements Tailer.TailerListener {
    public static final String MATCH_ALL = "*";
    private final Pattern pattern;
    private final String regex;
    private final PrintWriter pw;

    public FilteringListener(@NotNull PrintWriter pw, @Nullable String regex) {
        this.pw = pw;
        this.regex = regex != null ? regex.toLowerCase(Locale.ENGLISH) : null;
        this.pattern = FilteringListener.createPattern(regex);
    }

    @Override
    public void handle(@NotNull String line) {
        if (this.include(line)) {
            this.pw.println(line);
        }
    }

    private boolean include(@NotNull String line) {
        if (this.pattern == null) {
            return true;
        }
        String lc = line.toLowerCase(Locale.ENGLISH);
        if (lc.contains(this.regex)) {
            return true;
        }
        return this.pattern.matcher(line).matches();
    }

    private static Pattern createPattern(@Nullable String regex) {
        if (regex == null || MATCH_ALL.equals(regex)) {
            return null;
        }
        return Pattern.compile(regex);
    }
}

