/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.owasp.esapi.configuration.EsapiPropertyLoader;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;

public abstract class AbstractPrioritizedPropertyLoader
implements EsapiPropertyLoader,
Comparable<AbstractPrioritizedPropertyLoader> {
    protected final String filename;
    protected Properties properties;
    private final int priority;

    public AbstractPrioritizedPropertyLoader(String filename, int priority) throws IOException {
        this.priority = priority;
        this.filename = filename;
        this.initProperties();
    }

    public int priority() {
        return this.priority;
    }

    @Override
    public int compareTo(AbstractPrioritizedPropertyLoader compared) {
        if (this.priority > compared.priority()) {
            return 1;
        }
        if (this.priority < compared.priority()) {
            return -1;
        }
        return 0;
    }

    public String name() {
        return this.filename;
    }

    private void initProperties() throws IOException {
        this.properties = new Properties();
        File file = new File(this.filename);
        if (file.exists() && file.isFile()) {
            if (!file.canRead()) {
                throw new IOException("Can't read specificied configuration file: " + this.filename);
            }
        } else {
            throw new FileNotFoundException("Specified configuration file " + this.filename + " does not exist or not regular file");
        }
        this.loadPropertiesFromFile(file);
    }

    protected abstract void loadPropertiesFromFile(File var1);

    protected final void logSpecial(String msg, Throwable t) {
        DefaultSecurityConfiguration.logToStdout(msg, t);
    }

    protected final void logSpecial(String msg) {
        this.logSpecial(msg, null);
    }
}

